/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexAnnotationParser;
import hu.uw.pallergabor.dedexer.DexEncodedArrayParser;
import hu.uw.pallergabor.dedexer.DexFieldIdsBlock;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import hu.uw.pallergabor.dedexer.UnknownInstructionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DexClassDefsBlock
extends DexParser {
    public static final int ACCESS_PUBLIC = 1;
    public static final int ACCESS_PRIVATE = 2;
    public static final int ACCESS_PROTECTED = 4;
    public static final int ACCESS_STATIC = 8;
    public static final int ACCESS_FINAL = 16;
    public static final int ACCESS_VOLATILE = 64;
    public static final int ACCESS_TRANSIENT = 128;
    public static final int ACCESS_NATIVE = 256;
    public static final int ACCESS_INTERFACE = 512;
    public static final int ACCESS_ABSTRACT = 1024;
    public static final int ACCESS_STRICTFP = 2048;
    public static final int ACCESS_ANNOTATION = 8192;
    public static final int ACCESS_ENUM = 16384;
    public static final int DECLARED_SYNCHRONIZED = 131072;
    private HashMap<Integer, ClassHolder> classMap;
    private DexPointerBlock dexPointerBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexFieldIdsBlock dexFieldIdsBlock = null;
    private DexMethodIdsBlock dexMethodIdsBlock = null;
    private DexSignatureBlock dexSignatureBlock = null;

    @Override
    public void parse() throws IOException {
        TempClassHolder tempClassHolder;
        ClassHolder classHolder;
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        int classSize = (int)this.dexPointerBlock.getClassDefsSize();
        this.file.seek(this.dexPointerBlock.getClassDefsOffset());
        this.classMap = new HashMap();
        HashMap<Integer, TempClassHolder> tempClassMap = new HashMap<Integer, TempClassHolder>();
        for (int i = 0; i < classSize; ++i) {
            int classIdx = (int)this.read32Bit();
            classHolder = new ClassHolder();
            tempClassHolder = new TempClassHolder();
            classHolder.access = (int)this.read32Bit();
            classHolder.superclassTypeId = (int)this.read32Bit();
            tempClassHolder.interfacesOffset = this.readFileOffset();
            classHolder.sourceFileNameStringId = (int)this.read32Bit();
            tempClassHolder.annotationsOffset = this.readFileOffset();
            tempClassHolder.classDataOffset = this.readFileOffset();
            tempClassHolder.staticValuesOffset = this.readFileOffset();
            Integer mapKey = new Integer(classIdx);
            this.classMap.put(mapKey, classHolder);
            tempClassMap.put(mapKey, tempClassHolder);
            this.dump(this.accessFlagsToString(classHolder.access, ItemType.CLASS) + this.dexTypeIdsBlock.getClassName(classIdx));
        }
        for (Integer key : this.classMap.keySet()) {
            int i;
            classHolder = this.classMap.get(key);
            this.dump("// " + this.accessFlagsToString(classHolder.access, ItemType.CLASS) + " class " + this.dexTypeIdsBlock.getClassName(key) + ":");
            if (classHolder.superclassTypeId >= 0) {
                this.dump("// super: " + this.dexTypeIdsBlock.getClassName(classHolder.superclassTypeId));
            }
            if (classHolder.sourceFileNameStringId >= 0) {
                this.dump("// source: " + this.dexStringIdsBlock.getString(classHolder.sourceFileNameStringId));
            }
            tempClassHolder = (TempClassHolder)tempClassMap.get(key);
            if (tempClassHolder.interfacesOffset != 0L) {
                this.file.seek(tempClassHolder.interfacesOffset);
                int interfacesSize = (int)this.read32Bit();
                classHolder.interfaceTypes = new int[interfacesSize];
                for (i = 0; i < interfacesSize; ++i) {
                    classHolder.interfaceTypes[i] = this.read16Bit();
                    this.dump("// implements " + this.dexTypeIdsBlock.getType(classHolder.interfaceTypes[i]));
                }
            }
            if (tempClassHolder.classDataOffset != 0L) {
                int methodIdCounter;
                int i2;
                int fieldIdCounter;
                this.file.seek(tempClassHolder.classDataOffset);
                int staticFieldsSize = (int)this.readVLN();
                this.dump("static fields size: " + staticFieldsSize);
                int instanceFieldsSize = (int)this.readVLN();
                this.dump("instance fields size: " + instanceFieldsSize);
                int directMethodsSize = (int)this.readVLN();
                this.dump("direct methods size: " + directMethodsSize);
                int virtualMethodsSize = (int)this.readVLN();
                this.dump("virtual methods size: " + virtualMethodsSize);
                if (staticFieldsSize > 0) {
                    classHolder.staticFields = new FieldHolder[staticFieldsSize];
                    fieldIdCounter = 0;
                    for (i2 = 0; i2 < staticFieldsSize; ++i2) {
                        FieldHolder staticFieldHolder = new FieldHolder();
                        staticFieldHolder.fieldId = fieldIdCounter += (int)this.readVLN();
                        staticFieldHolder.access = (int)this.readVLN();
                        classHolder.staticFields[i2] = staticFieldHolder;
                        this.dump("// static field[" + i2 + "]: " + this.dexFieldIdsBlock.getFieldShortName(staticFieldHolder.fieldId));
                    }
                }
                if (instanceFieldsSize > 0) {
                    classHolder.instanceFields = new FieldHolder[instanceFieldsSize];
                    fieldIdCounter = 0;
                    for (i2 = 0; i2 < instanceFieldsSize; ++i2) {
                        FieldHolder instanceFieldHolder = new FieldHolder();
                        instanceFieldHolder.fieldId = fieldIdCounter += (int)this.readVLN();
                        instanceFieldHolder.access = (int)this.readVLN();
                        classHolder.instanceFields[i2] = instanceFieldHolder;
                        this.dump("// instance field[" + i2 + "]: " + this.dexFieldIdsBlock.getFieldShortName(instanceFieldHolder.fieldId));
                    }
                }
                if (directMethodsSize > 0) {
                    classHolder.directMethods = new MethodHolder[directMethodsSize];
                    methodIdCounter = 0;
                    for (i2 = 0; i2 < directMethodsSize; ++i2) {
                        MethodHolder directMethodHolder = new MethodHolder();
                        directMethodHolder.methodId = methodIdCounter += (int)this.readVLN();
                        directMethodHolder.access = (int)this.readVLN();
                        directMethodHolder.offset = this.readFileOffsetVLN();
                        classHolder.directMethods[i2] = directMethodHolder;
                        this.dump("// direct method[" + i2 + "]: " + this.dexMethodIdsBlock.getProto(directMethodHolder.methodId));
                    }
                }
                if (virtualMethodsSize > 0) {
                    classHolder.virtualMethods = new MethodHolder[virtualMethodsSize];
                    methodIdCounter = 0;
                    for (i2 = 0; i2 < virtualMethodsSize; ++i2) {
                        MethodHolder virtualMethodHolder = new MethodHolder();
                        virtualMethodHolder.methodId = methodIdCounter += (int)this.readVLN();
                        virtualMethodHolder.access = (int)this.readVLN();
                        virtualMethodHolder.offset = this.readFileOffsetVLN();
                        classHolder.virtualMethods[i2] = virtualMethodHolder;
                        this.dump("// virtual method[" + i2 + "]: " + this.dexMethodIdsBlock.getProto(virtualMethodHolder.methodId));
                    }
                }
            }
            if (tempClassHolder.staticValuesOffset != 0L) {
                DexEncodedArrayParser deap = new DexEncodedArrayParser();
                deap.setRandomAccessFile(this.file);
                deap.setDumpFile(this.dump);
                deap.setDexStringIdsBlock(this.dexStringIdsBlock);
                deap.setDexTypeIdsBlock(this.dexTypeIdsBlock);
                deap.setDexFieldIdsBlock(this.dexFieldIdsBlock);
                deap.setDexMethodIdsBlock(this.dexMethodIdsBlock);
                deap.setFilePosition(tempClassHolder.staticValuesOffset);
                deap.parse();
                for (i = 0; i < deap.getArraySize(); ++i) {
                    if (i >= classHolder.staticFields.length) continue;
                    FieldHolder fieldHolder = classHolder.staticFields[i];
                    fieldHolder.initialValue = deap.getArrayElement(i);
                }
            }
            if (tempClassHolder.annotationsOffset == 0L) continue;
            DexAnnotationParser dexAnnotationParser = new DexAnnotationParser();
            dexAnnotationParser.setRandomAccessFile(this.file);
            dexAnnotationParser.setDumpFile(this.dump);
            dexAnnotationParser.setDexTypeIdsBlock(this.dexTypeIdsBlock);
            dexAnnotationParser.setDexStringIdsBlock(this.dexStringIdsBlock);
            dexAnnotationParser.setDexFieldIdsBlock(this.dexFieldIdsBlock);
            dexAnnotationParser.setDexMethodIdsBlock(this.dexMethodIdsBlock);
            dexAnnotationParser.setDexSignatureBlock(this.dexSignatureBlock);
            try {
                dexAnnotationParser.parse(tempClassHolder.annotationsOffset);
            }
            catch (UnknownInstructionException ex) {
                // empty catch block
            }
            classHolder.annotationParser = dexAnnotationParser;
        }
    }

    public Iterator<Integer> getClassIterator() {
        return this.classMap.keySet().iterator();
    }

    public boolean isInterface(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return false;
        }
        return (classHolder.access & 0x200) != 0;
    }

    public String getClassName(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.accessFlagsToString(classHolder.access, ItemType.CLASS));
        b.append(this.dexTypeIdsBlock.getClassName(classIdx));
        return new String(b);
    }

    public String getClassNameOnly(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.dexTypeIdsBlock.getClassName(classIdx));
        return new String(b);
    }

    public String getSuperClass(int classIdx) {
        if (classIdx < 0) {
            return null;
        }
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        int superType = classHolder.superclassTypeId;
        if (superType < 0) {
            return null;
        }
        return this.dexTypeIdsBlock.getClassName(superType);
    }

    public String getSourceName(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        return classHolder.sourceFileNameStringId >= 0 ? this.dexStringIdsBlock.getString(classHolder.sourceFileNameStringId) : null;
    }

    public int getInterfacesSize(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        if (classHolder.interfaceTypes == null) {
            return 0;
        }
        return classHolder.interfaceTypes.length;
    }

    public String getInterface(int classIdx, int interfaceIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        return this.dexTypeIdsBlock.getClassName(classHolder.interfaceTypes[interfaceIdx]);
    }

    public int getStaticFieldsSize(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        if (classHolder.staticFields == null) {
            return 0;
        }
        return classHolder.staticFields.length;
    }

    public String getStaticField(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.staticFields[fieldIdx];
        return this.getFullFieldName(fieldHolder);
    }

    public String getStaticFieldShortName(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.staticFields[fieldIdx];
        return this.dexFieldIdsBlock.getFieldName(fieldHolder.fieldId);
    }

    public Object getStaticFieldInitializer(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.staticFields[fieldIdx];
        return fieldHolder.initialValue;
    }

    public int getInstanceFieldsSize(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        if (classHolder.instanceFields == null) {
            return 0;
        }
        return classHolder.instanceFields.length;
    }

    public String getInstanceField(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.instanceFields[fieldIdx];
        return this.getFullFieldName(fieldHolder);
    }

    public String getInstanceFieldShortName(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.instanceFields[fieldIdx];
        return this.dexFieldIdsBlock.getFieldName(fieldHolder.fieldId);
    }

    public String getInstanceFieldNameAndType(int classIdx, int fieldIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        FieldHolder fieldHolder = classHolder.instanceFields[fieldIdx];
        return this.dexFieldIdsBlock.getFieldShortName(fieldHolder.fieldId);
    }

    public int getDirectMethodsFieldsSize(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        if (classHolder.directMethods == null) {
            return 0;
        }
        return classHolder.directMethods.length;
    }

    public String getDirectMethodName(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.directMethods[methodIdx];
        return this.getFullMethodName(methodHolder);
    }

    public String getDirectMethodShortName(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.directMethods[methodIdx];
        return DexMethodIdsBlock.getMethodName(this.dexMethodIdsBlock.getMethod(methodHolder.methodId));
    }

    public int getDirectMethodAccess(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        MethodHolder methodHolder = classHolder.directMethods[methodIdx];
        return methodHolder.access;
    }

    public long getDirectMethodOffset(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1L;
        }
        MethodHolder methodHolder = classHolder.directMethods[methodIdx];
        return methodHolder.offset;
    }

    public ArrayList getDirectMethodParameterOffsets(int classIdx, int methodIdx, int regSize) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.directMethods[methodIdx];
        return this.getMethodParameterOffsets(methodHolder, regSize);
    }

    public int getVirtualMethodsFieldsSize(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        if (classHolder.virtualMethods == null) {
            return 0;
        }
        return classHolder.virtualMethods.length;
    }

    public String getVirtualMethodName(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return this.getFullMethodName(methodHolder);
    }

    public String getVirtualMethodShortName(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return DexMethodIdsBlock.getMethodName(this.dexMethodIdsBlock.getMethod(methodHolder.methodId));
    }

    public int getVirtualMethodId(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return methodHolder.methodId;
    }

    public int getVirtualMethodAccess(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return methodHolder.access;
    }

    public long getVirtualMethodOffset(int classIdx, int methodIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return -1L;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return methodHolder.offset;
    }

    public ArrayList getVirtualMethodParameterOffsets(int classIdx, int methodIdx, int regSize) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        MethodHolder methodHolder = classHolder.virtualMethods[methodIdx];
        return this.getMethodParameterOffsets(methodHolder, regSize);
    }

    public DexAnnotationParser getDexAnnotationParser(int classIdx) {
        Integer i = new Integer(classIdx);
        ClassHolder classHolder = this.classMap.get(i);
        if (classHolder == null) {
            return null;
        }
        return classHolder.annotationParser;
    }

    public static String getClassNameWithoutPackage(String fullClassName) {
        int idx = fullClassName.lastIndexOf(36);
        if (idx < 0) {
            return fullClassName;
        }
        String cn = fullClassName.substring(idx + 1);
        if (cn.endsWith(";")) {
            cn = cn.substring(0, cn.length() - 1);
        }
        return cn;
    }

    public static String getClassNameWithoutPrePostfix(String fullClassName) {
        String cn = fullClassName;
        if (cn.startsWith("L")) {
            cn = cn.substring(1);
        }
        if (cn.endsWith(";")) {
            cn = cn.substring(0, cn.length() - 1);
        }
        return cn;
    }

    public static ArrayList getMethodParameterOffsets(String proto, int regSize) {
        int idx2;
        int idx1 = proto.indexOf(40);
        if (idx1 < 0) {
            return null;
        }
        if ((idx2 = proto.indexOf(41, ++idx1)) < 0) {
            return null;
        }
        String parms = proto.substring(idx1, idx2);
        ArrayList<Object> returnList = new ArrayList<Object>();
        int idx = 0;
        int regIdx = 0;
        int allocLength = 0;
        int nextIdx = 0;
        while (idx < parms.length()) {
            switch (parms.charAt(idx)) {
                case '[': {
                    allocLength = 1;
                    while (nextIdx < parms.length() && parms.charAt(nextIdx) == '[') {
                        ++nextIdx;
                    }
                    if (nextIdx < parms.length() && parms.charAt(nextIdx) == 'L') {
                        nextIdx = (nextIdx = parms.indexOf(59, nextIdx)) < 0 ? parms.length() : nextIdx + 1;
                        break;
                    }
                    ++nextIdx;
                    break;
                }
                case 'L': {
                    allocLength = 1;
                    nextIdx = parms.indexOf(59, idx);
                    nextIdx = nextIdx < 0 ? parms.length() : nextIdx + 1;
                    break;
                }
                case 'D': 
                case 'J': {
                    nextIdx = idx + 1;
                    allocLength = 2;
                    break;
                }
                default: {
                    nextIdx = idx + 1;
                    allocLength = 1;
                }
            }
            String parm = parms.substring(idx, nextIdx);
            returnList.add(new Integer(regIdx));
            returnList.add(parm);
            idx = nextIdx;
            regIdx += allocLength;
        }
        int offset = regSize - regIdx;
        for (int i = 0; i < returnList.size(); i += 2) {
            int regOffset = (Integer)returnList.get(i);
            returnList.set(i, new Integer(regOffset + offset));
        }
        return returnList;
    }

    public static ArrayList<Boolean> getMethodParameterWidth(String proto) {
        int idx2;
        int idx1 = proto.indexOf(40);
        if (idx1 < 0) {
            return null;
        }
        if ((idx2 = proto.indexOf(41, ++idx1)) < 0) {
            return null;
        }
        String parms = proto.substring(idx1, idx2);
        ArrayList<Boolean> returnList = new ArrayList<Boolean>();
        int idx = 0;
        boolean allocLength = false;
        int nextIdx = 0;
        Boolean wideFlag = null;
        while (idx < parms.length()) {
            switch (parms.charAt(idx)) {
                case '[': {
                    wideFlag = Boolean.FALSE;
                    if (idx + 1 < parms.length() && parms.charAt(idx + 1) == 'L') {
                        nextIdx = parms.indexOf(59, idx);
                        nextIdx = nextIdx < 0 ? parms.length() : nextIdx + 1;
                        break;
                    }
                    nextIdx = idx + 2;
                    break;
                }
                case 'L': {
                    wideFlag = Boolean.FALSE;
                    nextIdx = parms.indexOf(59, idx);
                    nextIdx = nextIdx < 0 ? parms.length() : nextIdx + 1;
                    break;
                }
                case 'D': 
                case 'J': {
                    nextIdx = idx + 1;
                    wideFlag = Boolean.TRUE;
                    break;
                }
                default: {
                    nextIdx = idx + 1;
                    wideFlag = Boolean.FALSE;
                }
            }
            returnList.add(wideFlag);
            idx = nextIdx;
        }
        return returnList;
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexFieldIdsBlock(DexFieldIdsBlock dexFieldIdsBlock) {
        this.dexFieldIdsBlock = dexFieldIdsBlock;
    }

    public void setDexMethodIdsBlock(DexMethodIdsBlock dexMethodIdsBlock) {
        this.dexMethodIdsBlock = dexMethodIdsBlock;
    }

    public DexMethodIdsBlock getDexMethodIdsBlock() {
        return this.dexMethodIdsBlock;
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    private String accessFlagsToString(int accessFlags, ItemType itemType) {
        StringBuilder b = new StringBuilder();
        if ((accessFlags & 1) != 0) {
            b.append("public ");
        }
        if ((accessFlags & 2) != 0) {
            b.append("private ");
        }
        if ((accessFlags & 4) != 0) {
            b.append("protected ");
        }
        if ((accessFlags & 0x400) != 0) {
            b.append("abstract ");
        }
        if ((accessFlags & 8) != 0) {
            b.append("static ");
        }
        if ((accessFlags & 0x10) != 0) {
            b.append("final ");
        }
        if ((accessFlags & 0x40) != 0 && itemType == ItemType.FIELD) {
            b.append("volatile ");
        }
        if ((accessFlags & 0x80) != 0 && itemType == ItemType.FIELD) {
            b.append("transient ");
        }
        if ((accessFlags & 0x100) != 0 && itemType == ItemType.METHOD) {
            b.append("native ");
        }
        if ((accessFlags & 0x2000) != 0) {
            b.append("annotation ");
        }
        if ((accessFlags & 0x20000) != 0) {
            b.append("synchronized ");
        }
        return new String(b);
    }

    private String getFullFieldName(FieldHolder fieldHolder) {
        StringBuilder b = new StringBuilder();
        b.append(this.accessFlagsToString(fieldHolder.access, ItemType.FIELD));
        b.append(this.dexFieldIdsBlock.getFieldShortName(fieldHolder.fieldId));
        return new String(b);
    }

    private String getFullMethodName(MethodHolder methodHolder) {
        StringBuilder b = new StringBuilder();
        b.append(this.accessFlagsToString(methodHolder.access, ItemType.METHOD));
        b.append(this.dexMethodIdsBlock.getProto(methodHolder.methodId));
        return new String(b);
    }

    private ArrayList getMethodParameterOffsets(MethodHolder methodHolder, int regSize) {
        String proto = this.dexMethodIdsBlock.getProto(methodHolder.methodId);
        return DexClassDefsBlock.getMethodParameterOffsets(proto, regSize);
    }

    class MethodHolder {
        int methodId;
        int access;
        long offset;

        MethodHolder() {
        }
    }

    class FieldHolder {
        int fieldId;
        int access;
        Object initialValue;

        FieldHolder() {
        }
    }

    class ClassHolder {
        int access;
        int superclassTypeId;
        int sourceFileNameStringId;
        int[] interfaceTypes = null;
        FieldHolder[] staticFields = null;
        FieldHolder[] instanceFields = null;
        MethodHolder[] directMethods = null;
        MethodHolder[] virtualMethods = null;
        DexAnnotationParser annotationParser = null;

        ClassHolder() {
        }
    }

    class TempClassHolder {
        long interfacesOffset;
        long annotationsOffset;
        long classDataOffset;
        long staticValuesOffset;

        TempClassHolder() {
        }
    }

    private static enum ItemType {
        CLASS,
        FIELD,
        METHOD;

    }
}

