/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.IOException;
import java.util.ArrayList;

public class DexDependencyParser
extends DexParser {
    DexSignatureBlock dexSignatureBlock;
    ArrayList<String> depList = new ArrayList();

    public int getDependencySize() {
        return this.depList.size();
    }

    public String getDependencyElement(int idx) {
        return this.depList.get(idx);
    }

    @Override
    public void parse() throws IOException {
        this.setFilePosition(this.dexSignatureBlock.getDexOptimizationData().getDepsOffset());
        long modificationTimeStamp = this.read32Bit();
        this.dump("Modification timestamp: 0x" + Long.toHexString(modificationTimeStamp));
        long crc = this.read32Bit();
        this.dump("CRC: 0x" + Long.toHexString(crc));
        long dalvikVersion = this.read32Bit();
        this.dump("Dalvik version: 0x" + Long.toHexString(dalvikVersion));
        long numDeps = this.read32Bit();
        this.dump("Number of dependencies: " + numDeps);
        for (long l = 0L; l < numDeps; ++l) {
            long depLen = this.read32Bit();
            long pos = this.getFilePosition();
            this.dump("Length of dependency#" + l + ": " + depLen);
            StringBuilder sb = new StringBuilder();
            int c = 0;
            do {
                if ((c = this.file.read()) <= 0) continue;
                sb.append((char)c);
            } while (c > 0);
            String dep = new String(sb);
            this.depList.add(dep);
            this.dump("Dependency#" + l + " : " + dep);
            this.setFilePosition(pos + depLen + 20L);
        }
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }
}

