/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexOptimizationData;
import hu.uw.pallergabor.dedexer.DexParser;
import java.io.IOException;

public class DexSignatureBlock
extends DexParser {
    private OptVersion optVersion;
    private long checksum;
    private int[] signature = new int[20];

    @Override
    public void parse() throws IOException {
        this.parseExpected8Bit(100);
        this.parseExpected8Bit(101);
        int[] allowedBytes = new int[]{120, 121};
        int idx = this.parseExpected8BitValues(allowedBytes);
        boolean isOptimized = idx == 1;
        this.parseExpected8Bit(10);
        this.parseExpected8Bit(48);
        int[] allowedBytes2 = new int[]{51, 49};
        idx = this.parseExpected8BitValues(allowedBytes2);
        int[] allowedBytes3 = new int[]{54, 53, 51};
        int optVersionIdx = this.parseExpected8BitValues(allowedBytes3);
        this.parseExpected8Bit(0);
        if (isOptimized) {
            if (optVersionIdx == 0) {
                this.dump("magic: dey\\n036\\0");
            } else {
                this.dump("magic: dey\\n035\\0");
            }
        } else {
            this.dump("magic: dex\\n035\\0");
        }
        if (!isOptimized) {
            this.checksum = this.read32Bit();
            this.dump("checksum");
            for (int i = 0; i < 20; ++i) {
                this.signature[i] = this.read8Bit();
            }
            this.dump("signature");
        } else {
            long dexOffset = this.read32Bit();
            this.dump("DEX start offset: 0x" + Long.toHexString(dexOffset));
            long dexLength = this.read32Bit();
            this.dump("DEX length: 0x" + Long.toHexString(dexLength));
            long depsOffset = this.read32Bit();
            this.dump("Dependencies start offset: 0x" + Long.toHexString(depsOffset));
            long depsLength = this.read32Bit();
            this.dump("Dependencies length: 0x" + Long.toHexString(depsLength));
            long auxOffset = this.read32Bit();
            this.dump("Auxiliary data offset: 0x" + Long.toHexString(auxOffset));
            long auxLength = this.read32Bit();
            this.dump("Auxiliary data length: 0x" + Long.toHexString(auxLength));
            DexOptimizationData dexOptimizationData = new DexOptimizationData();
            dexOptimizationData.setDexOffset(dexOffset);
            dexOptimizationData.setDexLength(dexLength);
            dexOptimizationData.setDepsOffset(depsOffset);
            dexOptimizationData.setDepsLength(depsLength);
            dexOptimizationData.setAuxOffset(auxOffset);
            dexOptimizationData.setAuxLength(auxLength);
            this.optVersion = optVersionIdx == 0 ? OptVersion.OPTVERSION_36 : OptVersion.OPTVERSION_35;
            this.setDexOptimizationData(dexOptimizationData);
        }
    }

    public long getChecksum() {
        return this.checksum;
    }

    public int[] getSignature() {
        return this.signature;
    }

    public OptVersion getOptVersion() {
        return this.optVersion;
    }

    public void setOptVersion(OptVersion optVersion) {
        this.optVersion = optVersion;
    }

    public static enum OptVersion {
        OPTVERSION_35,
        OPTVERSION_36;

    }
}

